/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#include "mx_auto_config.h"
#include "myriexpress.h"
#if MX_OS_WINNT
#include "getopt.h"
#else
#include <unistd.h>
#include <netinet/in.h>
#endif
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stddef.h>
#include <errno.h>

#include "mx__lib_types.h"
#include "mx__lib.h"
#include "mx__driver_interface.h"
#include "mx__fops.h"

void
usage()
{
  fprintf(stderr, "Usage: mx_intr_coal [args]\n");
  fprintf(stderr, "-b - Board number [0]\n");
  fprintf(stderr, "-s - Set interrupt coalescing delay\n");
  fprintf(stderr, "-h - Help\n");
}

int 
main(int argc, char **argv)
{
  int c, do_set, result;
  mx_endpt_handle_t fd;
  extern char *optarg;
  mx_return_t ret;
  mx_intr_coal_t coal;
  
  do_set = 0;
  coal.board_number = 0;
  while ((c = getopt(argc, argv, "s:b:"))!= EOF) switch(c) {
  case 's':
    do_set = 1;
    coal.delay = atoi(optarg);
    break;
  case 'b':
    coal.board_number = atoi(optarg);
    break;
  case 'h':
  default:
    usage();
    exit(1);
  }
  
  mx_init();
  if ((ret = mx_open_any_board(&fd)) != MX_SUCCESS) {
    printf("open failed: %s\n", mx_strerror(ret));
    return 0;
  }
  if (do_set) {
    result = mx__set_intr_coal(fd, &coal);
    if (result) {
      perror("mx__set_intr_coal");
      exit(1);
    } 
  } else {
    result = mx__get_intr_coal(fd, &coal);
    if (result) {
      perror("mx__get_intr_coal");
      exit(1);
    }
  }
  printf("Interrupt coalescing delay is %d for instance %d\n",
	 (int)coal.delay, (int)coal.board_number);

  mx__close(fd);
  mx_finalize();
  return(0);
}
